/*
 * Decompiled with CFR 0.152.
 */
package com.casualhorizons.gulliverlite;

import com.casualhorizons.gulliverlite.GulliverLite;
import com.casualhorizons.gulliverlite.SizeUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;

public class AmethystStickItem
extends class_1792 {
    private static final String NBT_COOLDOWN = "Cooldown";
    private static final String NBT_MODE = "Mode";
    private static final float[] SCALES = SizeUtil.ALLOWED_SCALES;

    public AmethystStickItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand != class_1268.field_5808) {
            return new class_1271(class_1269.field_5811, (Object)user.method_5998(hand));
        }
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            long last;
            long now = world.method_8510();
            if (now - (last = stack.method_7948().method_10537(NBT_COOLDOWN)) < 8L) {
                return new class_1271(class_1269.field_5811, (Object)stack);
            }
            stack.method_7948().method_10544(NBT_COOLDOWN, now);
            int baseMode = AmethystStickItem.nearestModeFor(SizeUtil.getScale(user));
            int dir = user.method_5715() ? -1 : 1;
            int targetMode = AmethystStickItem.clamp(baseMode + dir, 0, SCALES.length - 1);
            stack.method_7948().method_10569(NBT_MODE, targetMode);
            float targetScale = SCALES[targetMode];
            SizeUtil.setExactScale(user, targetScale);
            user.method_7353((class_2561)class_2561.method_43470((String)("Size: " + this.sizeName(targetMode) + (GulliverLite.PEHKUI_LOADED ? "" : " (Pehkui not found)"))), true);
            float pitch = switch (targetMode) {
                case 0 -> 1.8f;
                case 1 -> 1.5f;
                case 2 -> 1.2f;
                case 3 -> 1.0f;
                case 4 -> 0.8f;
                default -> 0.6f;
            };
            world.method_8396(null, user.method_24515(), (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 0.8f, pitch);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    private static int nearestModeFor(float currentScale) {
        int best = 0;
        float bestDiff = Float.MAX_VALUE;
        for (int i = 0; i < SCALES.length; ++i) {
            float d = Math.abs(SCALES[i] - currentScale);
            if (!(d < bestDiff)) continue;
            bestDiff = d;
            best = i;
        }
        return best;
    }

    private static int clamp(int v, int lo, int hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    private String sizeName(int mode) {
        return switch (mode) {
            case 0 -> "Micro";
            case 1 -> "Tiny";
            case 2 -> "Small";
            case 3 -> "Normal";
            case 4 -> "Large";
            default -> "Huge";
        };
    }
}

