/*
 * Decompiled with CFR 0.152.
 */
package com.casualhorizons.gulliverlite;

import com.casualhorizons.gulliverlite.GulliverLite;
import com.casualhorizons.gulliverlite.SizeUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3481;

public final class FlowerHideHandler {
    private static final Map<UUID, class_1531> HIDERS = new ConcurrentHashMap<UUID, class_1531>();
    private static final Map<class_2338, UUID> FLOWER_AT = new ConcurrentHashMap<class_2338, UUID>();

    private FlowerHideHandler() {
    }

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            boolean alreadyHidden;
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            if (!(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 sp = (class_3222)player;
            class_2338 pos = hit.method_17777();
            class_2680 state = world.method_8320(pos);
            if (!FlowerHideHandler.isFlower(state)) {
                return class_1269.field_5811;
            }
            if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
                pos = pos.method_10074();
                state = world.method_8320(pos);
            }
            if (alreadyHidden = HIDERS.containsKey(sp.method_5667())) {
                FlowerHideHandler.unhide(sp, true);
                return class_1269.field_5812;
            }
            if (!sp.method_5715() && sp.method_5998(hand).method_7960() && SizeUtil.isSmallerThanNormal((class_1657)sp)) {
                FlowerHideHandler.hideInFlower(sp, pos, state);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 sp : server.method_3760().method_14571()) {
                boolean exit;
                class_1531 marker = HIDERS.get(sp.method_5667());
                if (marker == null) continue;
                boolean bl = exit = !SizeUtil.isSmallerThanNormal((class_1657)sp) || sp.method_29504() || sp.method_5715() || sp.method_5854() != marker || !marker.method_5805() || marker.method_37908().method_8320(marker.method_24515()).method_26215();
                if (exit) {
                    FlowerHideHandler.unhide(sp, true);
                    continue;
                }
                sp.field_6017 = 0.0f;
                sp.method_18799(class_243.field_1353);
                class_2338 base = marker.method_24515();
                class_2680 state = marker.method_37908().method_8320(base);
                if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
                    base = base.method_10074();
                    state = marker.method_37908().method_8320(base);
                }
                class_243 anchor = FlowerHideHandler.anchorPos(base, state);
                if (marker.method_19538().method_24802((class_2374)anchor, 0.001)) continue;
                marker.method_5808(anchor.field_1352, anchor.field_1351, anchor.field_1350, marker.method_36454(), marker.method_36455());
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            class_3222 sp;
            UUID who;
            if (world.method_8608()) {
                return true;
            }
            if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
                pos = pos.method_10074();
            }
            if ((who = FLOWER_AT.remove(pos)) != null && player.method_5682() != null && (sp = player.method_5682().method_3760().method_14602(who)) != null) {
                FlowerHideHandler.unhide(sp, false);
            }
            return true;
        });
    }

    private static boolean isFlower(class_2680 state) {
        return state.method_26164(class_3481.field_20339) || state.method_26164(class_3481.field_20338);
    }

    private static class_243 anchorPos(class_2338 base, class_2680 state) {
        boolean tall = state.method_26164(class_3481.field_20338);
        double y = (double)base.method_10264() + (tall ? 1.0 : 0.5);
        return new class_243((double)base.method_10263() + 0.5, y, (double)base.method_10260() + 0.5);
    }

    private static void hideInFlower(class_3222 sp, class_2338 base, class_2680 state) {
        class_1937 world = sp.method_37908();
        if (HIDERS.containsKey(sp.method_5667())) {
            return;
        }
        class_1531 stand = new class_1531(class_1299.field_6131, world);
        stand.method_5648(true);
        stand.method_5684(true);
        stand.method_5875(true);
        stand.method_5803(true);
        stand.method_5841().method_12778(class_1531.field_7107, (Object)16);
        stand.field_5960 = true;
        class_243 pos = FlowerHideHandler.anchorPos(base, state);
        stand.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, 0.0f, 0.0f);
        world.method_8649((class_1297)stand);
        sp.method_5873((class_1297)stand, true);
        sp.method_5648(true);
        HIDERS.put(sp.method_5667(), stand);
        FLOWER_AT.put(base.method_10062(), sp.method_5667());
        GulliverLite.LOGGER.info("[FlowerBend] {} hid in flower at {}", (Object)sp.method_5820(), (Object)base);
    }

    private static void unhide(class_3222 sp, boolean removeMarker) {
        class_1531 marker = HIDERS.remove(sp.method_5667());
        if (marker != null) {
            FLOWER_AT.values().remove(sp.method_5667());
            if (sp.method_5765() && sp.method_5854() == marker) {
                sp.method_5848();
            }
            sp.method_5648(false);
            class_243 p = sp.method_19538();
            class_243 fwd = sp.method_5828(1.0f).method_1021(0.4);
            sp.method_5859(p.field_1352 + fwd.field_1352, p.field_1351, p.field_1350 + fwd.field_1350);
            if (removeMarker && marker.method_5805()) {
                marker.method_31472();
            }
            GulliverLite.LOGGER.info("[FlowerBend] {} exited flower", (Object)sp.method_5820());
        }
    }
}

