/*
 * Decompiled with CFR 0.152.
 */
package com.casualhorizons.gulliverlite;

import com.casualhorizons.gulliverlite.CarryManager;
import com.casualhorizons.gulliverlite.SizeUtil;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public final class GiantStomp {
    private static final ConcurrentHashMap<UUID, State> STATES = new ConcurrentHashMap();

    private GiantStomp() {
    }

    public static void tick(class_3222 p) {
        if (p.method_7325()) {
            return;
        }
        float scale = SizeUtil.getScale((class_1657)p);
        boolean giant = scale > 1.0f;
        State s = STATES.computeIfAbsent(p.method_5667(), id -> new State());
        if (s.cooldownTicks > 0) {
            --s.cooldownTicks;
        }
        boolean onGround = p.method_24828();
        boolean sneaking = p.method_5715();
        if (giant && !onGround && sneaking && p.method_18798().field_1351 < -0.08 && p.field_6017 > 0.8f) {
            s.armed = true;
        }
        if (onGround && !s.wasOnGround) {
            if (giant && s.armed && s.cooldownTicks == 0 && sneaking && p.field_6017 > 1.5f) {
                GiantStomp.doStomp(p, scale, p.field_6017);
                s.cooldownTicks = 120;
            }
            s.armed = false;
        }
        s.wasOnGround = onGround;
    }

    private static void doStomp(class_3222 p, float scale, float fallDistance) {
        class_3218 world = p.method_51469();
        double radius = GiantStomp.clamp(2.5 + ((double)scale - 1.0) * 2.0 + (double)fallDistance * 0.6, 2.5, 12.0);
        float damage = (float)GiantStomp.clamp(4.0 + ((double)scale - 1.0) * 5.0 + (double)fallDistance * 0.7, 4.0, 26.0);
        class_243 center = p.method_19538().method_1031(0.0, 0.1, 0.0);
        class_238 area = new class_238(center, center).method_1009(radius, 1.2, radius);
        class_1297 carried = CarryManager.getCarried((class_1657)p);
        world.method_8396(null, p.method_24515(), class_3417.field_15152, class_3419.field_15248, 0.9f, 1.15f);
        world.method_14199((class_2394)class_2398.field_11204, p.method_23317(), p.method_23318(), p.method_23321(), 80, radius * 0.35, 0.2, radius * 0.35, 0.05);
        world.method_14199((class_2394)class_2398.field_11203, p.method_23317(), p.method_23318(), p.method_23321(), 35, radius * 0.25, 0.1, radius * 0.25, 0.03);
        class_1282 dmg = p.method_48923().method_48802((class_1657)p);
        double kbBase = GiantStomp.clamp(0.4 + (double)fallDistance * 0.04 + ((double)scale - 1.0) * 0.15, 0.4, 1.4);
        double kbUp = GiantStomp.clamp(0.25 + ((double)scale - 1.0) * 0.12, 0.25, 0.85);
        for (class_1297 e : world.method_8333((class_1297)p, area, ent -> ent instanceof class_1309 && ent.method_5805())) {
            if (e == p || e == carried) continue;
            class_1309 le = (class_1309)e;
            le.method_5643(dmg, damage);
            class_243 push = le.method_19538().method_1020(p.method_19538());
            double len = Math.max(0.001, Math.sqrt(push.field_1352 * push.field_1352 + push.field_1350 * push.field_1350));
            class_243 horiz = new class_243(push.field_1352 / len, 0.0, push.field_1350 / len);
            class_243 current = le.method_18798();
            class_243 added = horiz.method_1021(kbBase).method_1031(0.0, kbUp, 0.0);
            le.method_18799(current.method_1019(added));
            le.field_6007 = true;
        }
        p.field_6017 = Math.max(0.0f, p.field_6017 - 3.0f);
    }

    private static double clamp(double v, double a, double b) {
        return Math.max(a, Math.min(b, v));
    }

    private static final class State {
        boolean wasOnGround = true;
        boolean armed = false;
        int cooldownTicks = 0;

        private State() {
        }
    }
}

