/*
 * Decompiled with CFR 0.152.
 */
package com.casualhorizons.gulliverlite;

import com.casualhorizons.gulliverlite.HideyMarkerBlock;
import com.casualhorizons.gulliverlite.ModBlocks;
import com.casualhorizons.gulliverlite.ModItems;
import com.casualhorizons.gulliverlite.SizeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class HideyHomes {
    private static final Map<UUID, Boolean> WAS_ON_GROUND = new HashMap<UUID, Boolean>();
    private static final int EXIT_CD_TICKS = 10;
    private static final int GESTURE_WINDOW = 20;
    private static final Map<UUID, SneakStage> SNEAK_STAGE = new HashMap<UUID, SneakStage>();
    private static final Map<UUID, Integer> SNEAK_TIMER = new HashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> WAS_SNEAKING = new HashMap<UUID, Boolean>();
    public static final class_5321<class_1937> ANT_DIM = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("gulliverlite", "ant_pockets"));
    private static final int ROOM_W = 18;
    private static final int ROOM_H = 18;
    private static final int ROOM_D = 18;
    private static final int SPACING = 36;
    private static final class_2680 EXIT_PLATE = class_2246.field_10582.method_9564();
    private static final Map<UUID, EntranceRef> LAST_ENTRANCE = new HashMap<UUID, EntranceRef>();
    private static final Map<UUID, Integer> EXIT_CD = new HashMap<UUID, Integer>();

    private HideyHomes() {
    }

    private static void resetSneak(UUID id) {
        SNEAK_STAGE.put(id, SneakStage.IDLE);
        SNEAK_TIMER.put(id, 0);
    }

    private static boolean handleDoubleSneak(class_3222 sp) {
        UUID id = sp.method_5667();
        boolean sneaking = sp.method_5715();
        boolean was = WAS_SNEAKING.getOrDefault(id, false);
        WAS_SNEAKING.put(id, sneaking);
        int t = Math.max(0, SNEAK_TIMER.getOrDefault(id, 0) - 1);
        SNEAK_TIMER.put(id, t);
        SneakStage stage = SNEAK_STAGE.getOrDefault(id, SneakStage.IDLE);
        boolean crouchDown = !was && sneaking;
        boolean crouchUp = was && !sneaking;
        switch (stage) {
            case IDLE: {
                if (!crouchDown) break;
                SNEAK_STAGE.put(id, SneakStage.FIRST_CROUCH);
                SNEAK_TIMER.put(id, 20);
                break;
            }
            case FIRST_CROUCH: {
                if (t == 0) {
                    HideyHomes.resetSneak(id);
                    break;
                }
                if (!crouchUp) break;
                SNEAK_STAGE.put(id, SneakStage.RELEASED);
                SNEAK_TIMER.put(id, 20);
                break;
            }
            case RELEASED: {
                if (t == 0) {
                    HideyHomes.resetSneak(id);
                    break;
                }
                if (!crouchDown) break;
                HideyHomes.resetSneak(id);
                return true;
            }
        }
        return false;
    }

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (world.field_9236 || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 sp = (class_3222)player;
            if (sp.method_6047().method_31574(ModItems.HIDEY_WAND) || sp.method_6079().method_31574(ModItems.HIDEY_WAND)) {
                return class_1269.field_5811;
            }
            class_3218 sw = (class_3218)world;
            class_2338 clicked = hit.method_17777();
            class_2338 base = HideyHomes.resolveEntranceBase(sw, clicked);
            if (base == null) {
                return class_1269.field_5811;
            }
            if (SizeUtil.isSmallerThanNormal((class_1657)sp)) {
                HideyHomes.rememberEntrance(sw, sp, base);
                HideyHomes.enterFrom(sp, sw, base);
                return class_1269.field_5812;
            }
            sp.method_7353((class_2561)class_2561.method_43470((String)"You need to be tiny to enter.").method_27692(class_124.field_1080), true);
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, dir) -> {
            if (world.field_9236 || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 sp = (class_3222)player;
            if (world.method_27983() == ANT_DIM) {
                class_2680 st = world.method_8320(pos);
                if (st.method_27852(class_2246.field_10582)) {
                    return class_1269.field_5811;
                }
                if (HideyHomes.isProtectedPocketBlock((class_3218)world, pos)) {
                    sp.field_13987.method_14364((class_2596)new class_2626((class_1922)((class_3218)world), pos));
                    sp.field_13987.method_14364((class_2596)new class_2620(sp.method_5628(), pos, -1));
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (world.field_9236 || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 sp = (class_3222)player;
            if (world.method_8320(hit.method_17777()).method_27852(class_2246.field_10582)) {
                EntranceRef ref = HideyHomes.getExitRef(sp);
                if (ref != null) {
                    HideyHomes.exitTo(sp, world.method_8503().method_3847(ref.worldKey()), ref.pos());
                    return class_1269.field_5812;
                }
                sp.method_7353((class_2561)class_2561.method_43470((String)"No exit mapped for this room.").method_27692(class_124.field_1061), true);
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.BEFORE.register((world1, player, pos, state, be) -> {
            if (world1.method_8608()) {
                return true;
            }
            class_3218 sw = (class_3218)world1;
            if (sw.method_27983() == ANT_DIM && HideyHomes.isProtectedPocketBlock(sw, pos)) {
                if (state.method_27852(class_2246.field_10582)) {
                    if (player instanceof class_3222) {
                        class_3222 sp = (class_3222)player;
                        sp.method_7353((class_2561)class_2561.method_43470((String)"Pressure plate removed. Double sneak to exit hole.").method_27692(class_124.field_1054), true);
                    }
                    return true;
                }
                if (player instanceof class_3222) {
                    class_3222 sp = (class_3222)player;
                    sp.method_7353((class_2561)class_2561.method_43470((String)"This wall is reinforced.").method_27692(class_124.field_1080), true);
                }
                return false;
            }
            if (state.method_27852(ModBlocks.HIDEY_MARKER)) {
                if (player instanceof class_3222) {
                    class_3222 sp = (class_3222)player;
                    sp.method_7353((class_2561)class_2561.method_43470((String)"The hidey entrance is fixed in place.").method_27692(class_124.field_1080), true);
                }
                return false;
            }
            HideyHomes.removeIfPresent(sw, pos);
            return true;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1533 frame;
            if (world.field_9236 || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 sp = (class_3222)player;
            if (entity instanceof class_1533 && HideyHomes.isProtectedHoleFrame((class_3218)world, frame = (class_1533)entity)) {
                sp.method_7353((class_2561)class_2561.method_43470((String)"The hidey entrance is fixed in place.").method_27692(class_124.field_1080), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 sp : server.method_3760().method_14571()) {
                EXIT_CD.put(sp.method_5667(), Math.max(0, EXIT_CD.getOrDefault(sp.method_5667(), 0) - 1));
                if (sp.method_51469().method_27983() != ANT_DIM) {
                    HideyHomes.resetSneak(sp.method_5667());
                    continue;
                }
                boolean gesture = HideyHomes.handleDoubleSneak(sp);
                class_2338 under = sp.method_24515().method_10074();
                boolean onPlate = sp.method_51469().method_8320(under).method_27852(class_2246.field_10582);
                if (!gesture && !onPlate || EXIT_CD.getOrDefault(sp.method_5667(), 0) != 0) continue;
                EntranceRef ref = HideyHomes.getExitRef(sp);
                if (ref != null) {
                    HideyHomes.exitTo(sp, server.method_3847(ref.worldKey()), ref.pos());
                    EXIT_CD.put(sp.method_5667(), 10);
                    continue;
                }
                sp.method_7353((class_2561)class_2561.method_43470((String)"No exit mapped for this room.").method_27692(class_124.field_1061), true);
            }
        });
    }

    private static boolean onAnyIronPlatePowered(class_3222 sp) {
        class_2338 under;
        class_3218 w = sp.method_51469();
        class_2680 st = w.method_8320(under = sp.method_24515().method_10074());
        if (!st.method_27852(class_2246.field_10582)) {
            return false;
        }
        Integer power = st.method_28498((class_2769)class_2741.field_12511) ? (Integer)st.method_11654((class_2769)class_2741.field_12511) : Integer.valueOf(0);
        return power != null && power > 0;
    }

    private static boolean plateJumpTriggered(class_3222 sp) {
        boolean prevOnGround = WAS_ON_GROUND.getOrDefault(sp.method_5667(), true);
        boolean nowOnGround = sp.method_24828();
        WAS_ON_GROUND.put(sp.method_5667(), nowOnGround);
        if (sp.method_51469().method_27983() != ANT_DIM) {
            return false;
        }
        if (!HideyHomes.onAnyIronPlatePowered(sp)) {
            return false;
        }
        return prevOnGround && !nowOnGround;
    }

    private static EntranceRef getExitRef(class_3222 sp) {
        EntranceRef ref = LAST_ENTRANCE.get(sp.method_5667());
        if (ref != null) {
            return ref;
        }
        return HideyHomes.resolveExitFromCurrentRoom(sp);
    }

    private static class_2680 normalizeWallMaterial(class_2680 base) {
        class_2248 b = base.method_26204();
        if (base.method_26225() && base.method_26234(null, class_2338.field_10980)) {
            return base;
        }
        if (b instanceof class_2482 || b instanceof class_2510 || b instanceof class_2397) {
            return class_2246.field_10360.method_9564();
        }
        return class_2246.field_10360.method_9564();
    }

    private static State getState(class_3218 world) {
        return (State)world.method_17983().method_17924(State::readNbt, State::new, "gulliverlite_hidey_homes");
    }

    public static boolean bindEntrance(class_3222 sp, class_1937 world, class_2338 basePos, class_2350 face) {
        class_2338 origin;
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 sw = (class_3218)world;
        if (sw.method_8320(basePos).method_26215()) {
            return false;
        }
        class_3218 pocket = sw.method_8503().method_3847(ANT_DIM);
        if (pocket == null) {
            return false;
        }
        State state = HideyHomes.getState(sw);
        long key = basePos.method_10063();
        if (!state.posToRoom.containsKey(key)) {
            Long dormantOrigin = state.dormant.remove(key);
            if (dormantOrigin != null) {
                state.posToRoom.put(key, dormantOrigin);
                origin = class_2338.method_10092((long)dormantOrigin);
            } else {
                class_2680 chosen = HideyHomes.normalizeWallMaterial(sw.method_8320(basePos));
                origin = HideyHomes.allocateAndBuild(pocket, state, chosen);
                state.posToRoom.put(key, origin.method_10063());
                class_2960 id = class_7923.field_41175.method_10221((Object)chosen.method_26204());
                state.roomMaterial.put(origin.method_10063(), id.toString());
            }
        } else {
            origin = class_2338.method_10092((long)state.posToRoom.get(key));
        }
        HideyHomes.ensureHoleFrame(sw, basePos, face, state);
        class_2338 playerStand = sp.method_24515();
        class_2338 safe = HideyHomes.findSafeExit(sw, playerStand);
        HideyHomes.ensureDefaultExitForRoom(state, origin, sw, safe);
        state.method_80();
        return true;
    }

    public static boolean unbindEntrance(class_3222 sp, class_1937 world, class_2338 basePos) {
        String uid;
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 sw = (class_3218)world;
        State state = HideyHomes.getState(sw);
        long k = basePos.method_10063();
        Long origin = state.posToRoom.remove(k);
        if (origin != null) {
            state.dormant.put(k, origin);
        }
        if ((uid = state.posToFrame.remove(k)) != null) {
            try {
                long markerL = Long.parseLong(uid);
                class_2338 mp = class_2338.method_10092((long)markerL);
                if (sw.method_8320(mp).method_27852(ModBlocks.HIDEY_MARKER)) {
                    sw.method_8652(mp, class_2246.field_10124.method_9564(), 3);
                }
            }
            catch (NumberFormatException ignored) {
                try {
                    class_1297 ent = sw.method_14190(UUID.fromString(uid));
                    if (ent != null) {
                        ent.method_31472();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (origin != null) {
            state.method_80();
        }
        return origin != null;
    }

    public static boolean isEntrance(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 sw = (class_3218)world;
        if (HideyHomes.getState((class_3218)sw).posToRoom.containsKey(pos.method_10063())) {
            return true;
        }
        State st = HideyHomes.getState(sw);
        String as = Long.toString(pos.method_10063());
        return st.posToFrame.containsValue(as);
    }

    public static void enterFrom(class_3222 sp, class_3218 world, class_2338 basePos) {
        State s = HideyHomes.getState(world);
        Long roomL = s.posToRoom.get(basePos.method_10063());
        if (roomL == null) {
            return;
        }
        class_3218 pocket = world.method_8503().method_3847(ANT_DIM);
        if (pocket == null) {
            sp.method_7353((class_2561)class_2561.method_43470((String)"Hidey dimension is missing.").method_27692(class_124.field_1061), true);
            return;
        }
        class_2338 origin = class_2338.method_10092((long)roomL);
        class_2338 spawn = origin.method_10069(9, 1, 15);
        HideyHomes.teleport(sp, (class_5321<class_1937>)pocket.method_27983(), spawn, class_2350.field_11043);
        SizeUtil.setExactScale((class_1657)sp, 1.0f);
        HideyHomes.rememberEntrance(world, sp, basePos);
        if (!s.roomExitBase.containsKey(origin.method_10063())) {
            class_2338 safe = HideyHomes.findSafeExit(world, basePos);
            HideyHomes.ensureDefaultExitForRoom(s, origin, world, safe);
        }
        if (!HideyHomes.roomHasAnyIronPlate(pocket, origin)) {
            sp.method_7353((class_2561)class_2561.method_43470((String)"Tip: Double sneak to exit hole. Any iron pressure plate inside can be used to exit.").method_27692(class_124.field_1080), true);
        }
        sp.method_7353((class_2561)class_2561.method_43470((String)"You slip into the hidey home...").method_27692(class_124.field_1077), true);
    }

    public static void exitTo(class_3222 sp, class_3218 targetWorld, class_2338 basePos) {
        if (targetWorld == null) {
            sp.method_7353((class_2561)class_2561.method_43470((String)"Exit target missing.").method_27692(class_124.field_1061), true);
            return;
        }
        class_2338 out = HideyHomes.findSafeExit(targetWorld, basePos);
        class_2350 face = HideyHomes.getBoundFace(targetWorld, basePos);
        HideyHomes.teleport(sp, (class_5321<class_1937>)targetWorld.method_27983(), out, face != null ? face : class_2350.field_11043);
    }

    private static void ensureDefaultExitForRoom(State st, class_2338 roomOrigin, class_3218 exitWorld, class_2338 exitBase) {
        long k = roomOrigin.method_10063();
        if (!st.roomExitBase.containsKey(k)) {
            st.roomExitBase.put(k, exitBase.method_10063());
            st.roomExitWorld.put(k, exitWorld.method_27983().method_29177().toString());
            st.method_80();
        }
    }

    private static EntranceRef resolveExitFromCurrentRoom(class_3222 sp) {
        if (sp.method_51469().method_27983() != ANT_DIM) {
            return null;
        }
        class_3218 pocket = sp.method_51469();
        State st = HideyHomes.getState(sp.method_5682().method_30002());
        class_2338 p = sp.method_24515();
        class_2338 foundOrigin = null;
        for (long v : st.posToRoom.values()) {
            class_2338 origin = class_2338.method_10092((long)v);
            if (p.method_10263() < origin.method_10263() || p.method_10263() >= origin.method_10263() + 18 || p.method_10264() < origin.method_10264() || p.method_10264() >= origin.method_10264() + 18 || p.method_10260() < origin.method_10260() || p.method_10260() >= origin.method_10260() + 18) continue;
            foundOrigin = origin;
            break;
        }
        if (foundOrigin == null) {
            return null;
        }
        long k = foundOrigin.method_10063();
        Long baseL = st.roomExitBase.get(k);
        String worldId = st.roomExitWorld.get(k);
        if (baseL == null || worldId == null) {
            class_2338 baseFromReverse = null;
            for (Map.Entry<Long, Long> e : st.posToRoom.entrySet()) {
                if (e.getValue() != k) continue;
                baseFromReverse = class_2338.method_10092((long)e.getKey());
                break;
            }
            if (baseFromReverse != null) {
                class_5321 wk = class_1937.field_25179;
                return new EntranceRef((class_5321<class_1937>)wk, baseFromReverse);
            }
            return null;
        }
        class_5321 wk = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(worldId));
        class_3218 exitWorld = sp.method_5682().method_3847(wk);
        if (exitWorld == null) {
            return null;
        }
        return new EntranceRef((class_5321<class_1937>)wk, class_2338.method_10092((long)baseL));
    }

    private static void rememberEntrance(class_3218 world, class_3222 sp, class_2338 base) {
        LAST_ENTRANCE.put(sp.method_5667(), new EntranceRef((class_5321<class_1937>)world.method_27983(), base.method_10062()));
    }

    private static void removeIfPresent(class_3218 sw, class_2338 pos) {
        Long origin;
        if (sw.method_27983() == ANT_DIM) {
            return;
        }
        State st = HideyHomes.getState(sw);
        long k = pos.method_10063();
        String uid = st.posToFrame.remove(k);
        if (uid != null) {
            try {
                long m = Long.parseLong(uid);
                class_2338 mp = class_2338.method_10092((long)m);
                if (sw.method_8320(mp).method_27852(ModBlocks.HIDEY_MARKER)) {
                    sw.method_8652(mp, class_2246.field_10124.method_9564(), 3);
                }
            }
            catch (NumberFormatException ignored) {
                try {
                    class_1297 ent = sw.method_14190(UUID.fromString(uid));
                    if (ent != null) {
                        ent.method_31472();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if ((origin = st.posToRoom.remove(k)) != null) {
            st.dormant.put(k, origin);
        }
        if (origin != null) {
            st.method_80();
        }
    }

    private static class_2338 allocateAndBuild(class_3218 pocket, State st, class_2680 wallMat) {
        int x0;
        int z0;
        int y;
        int x = st.nextX * 36;
        int z = st.nextZ * 36;
        st.nextX = (st.nextX + 1) % 512;
        if (st.nextX == 0) {
            ++st.nextZ;
        }
        class_2338 origin = new class_2338(x, 64, z);
        class_2680 AIR = class_2246.field_10124.method_9564();
        class_2680 WALL = wallMat;
        class_2680 LAMP = class_2246.field_10174.method_9564();
        for (y = 0; y < 18; ++y) {
            for (z0 = 0; z0 < 18; ++z0) {
                for (int x02 = 0; x02 < 18; ++x02) {
                    pocket.method_8652(origin.method_10069(x02, y, z0), AIR, 3);
                }
            }
        }
        for (int z02 = 0; z02 < 18; ++z02) {
            for (x0 = 0; x0 < 18; ++x0) {
                pocket.method_8652(origin.method_10069(x0, 0, z02), WALL, 3);
                pocket.method_8652(origin.method_10069(x0, 17, z02), WALL, 3);
            }
        }
        for (y = 0; y < 18; ++y) {
            for (x0 = 0; x0 < 18; ++x0) {
                pocket.method_8652(origin.method_10069(x0, y, 0), WALL, 3);
                pocket.method_8652(origin.method_10069(x0, y, 17), WALL, 3);
            }
            for (z0 = 0; z0 < 18; ++z0) {
                pocket.method_8652(origin.method_10069(0, y, z0), WALL, 3);
                pocket.method_8652(origin.method_10069(17, y, z0), WALL, 3);
            }
        }
        pocket.method_8652(origin.method_10069(9, 16, 9), LAMP, 3);
        pocket.method_8652(origin.method_10069(9, 1, 16), EXIT_PLATE, 3);
        st.method_80();
        return origin;
    }

    private static void ensureHoleFrame(class_3218 world, class_2338 basePos, class_2350 face, State st) {
        class_2338 markerPos = basePos.method_10093(face);
        if (!world.method_8320(markerPos).method_26215()) {
            for (class_2350 d : class_2350.class_2353.field_11062) {
                class_2338 p = basePos.method_10093(d);
                if (!world.method_8320(p).method_26215()) continue;
                markerPos = p;
                face = d;
                break;
            }
        }
        world.method_8501(markerPos, (class_2680)ModBlocks.HIDEY_MARKER.method_9564().method_11657((class_2769)HideyMarkerBlock.FACING, (Comparable)face));
        st.posToFrame.put(basePos.method_10063(), "" + markerPos.method_10063());
    }

    private static boolean isProtectedPocketBlock(class_3218 world, class_2338 pos) {
        if (world.method_27983() != ANT_DIM) {
            return false;
        }
        State st = HideyHomes.getState(world.method_8503().method_30002());
        State thisState = HideyHomes.getState(world);
        return HideyHomes.isInAnyRoomShell(pos, st) || HideyHomes.isInAnyRoomShell(pos, thisState);
    }

    private static boolean isInAnyRoomShell(class_2338 pos, State st) {
        if (st == null) {
            return false;
        }
        for (long v : st.posToRoom.values()) {
            class_2338 origin = class_2338.method_10092((long)v);
            if (!HideyHomes.isShellPos(origin, pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean roomHasAnyIronPlate(class_3218 pocket, class_2338 origin) {
        for (int y = 0; y < 18; ++y) {
            for (int z = 0; z < 18; ++z) {
                for (int x = 0; x < 18; ++x) {
                    if (!pocket.method_8320(origin.method_10069(x, y, z)).method_27852(class_2246.field_10582)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isShellPos(class_2338 origin, class_2338 p) {
        int rx = p.method_10263() - origin.method_10263();
        int ry = p.method_10264() - origin.method_10264();
        int rz = p.method_10260() - origin.method_10260();
        if (rx < 0 || ry < 0 || rz < 0 || rx >= 18 || ry >= 18 || rz >= 18) {
            return false;
        }
        return rx == 0 || rx == 17 || ry == 0 || ry == 17 || rz == 0 || rz == 17;
    }

    private static void teleport(class_3222 sp, class_5321<class_1937> key, class_2338 pos, class_2350 face) {
        class_3218 dst = sp.method_5682().method_3847(key);
        if (dst == null) {
            return;
        }
        float yaw = switch (face) {
            case class_2350.field_11043 -> 180.0f;
            case class_2350.field_11035 -> 0.0f;
            case class_2350.field_11039 -> 90.0f;
            case class_2350.field_11034 -> -90.0f;
            default -> sp.method_36454();
        };
        sp.method_14251(dst, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.01, (double)pos.method_10260() + 0.5, yaw, sp.method_36455());
        sp.field_6017 = 0.0f;
        sp.method_18800(0.0, 0.0, 0.0);
    }

    private static boolean isProtectedHoleFrame(class_3218 world, class_1533 frame) {
        class_1799 s = frame.method_6940();
        if (!s.method_31574(ModItems.HIDEY_HOLE_PLATE)) {
            return false;
        }
        class_2338 backing = frame.method_6896();
        return HideyHomes.isEntrance((class_1937)world, backing);
    }

    private static class_2338 resolveEntranceBase(class_3218 sw, class_2338 clickedPos) {
        State st = HideyHomes.getState(sw);
        long l = clickedPos.method_10063();
        if (st.posToRoom.containsKey(l)) {
            return clickedPos;
        }
        String markerStr = Long.toString(l);
        for (Map.Entry<Long, Long> e : st.posToRoom.entrySet()) {
            String storedMarker = st.posToFrame.get(e.getKey());
            if (!markerStr.equals(storedMarker)) continue;
            return class_2338.method_10092((long)e.getKey());
        }
        return null;
    }

    private static class_2350 getBoundFace(class_3218 sw, class_2338 base) {
        State st = HideyHomes.getState(sw);
        String mStr = st.posToFrame.get(base.method_10063());
        if (mStr == null) {
            return null;
        }
        try {
            class_2338 marker = class_2338.method_10092((long)Long.parseLong(mStr));
            int dx = marker.method_10263() - base.method_10263();
            int dy = marker.method_10264() - base.method_10264();
            int dz = marker.method_10260() - base.method_10260();
            for (class_2350 d : class_2350.values()) {
                if (d.method_10148() != dx || d.method_10164() != dy || d.method_10165() != dz) continue;
                return d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isTwoHighAirWithFloor(class_3218 w, class_2338 p) {
        return w.method_22347(p) && w.method_22347(p.method_10084()) && !w.method_8320(p.method_10074()).method_26215();
    }

    private static class_2338 findSafeExit(class_3218 w, class_2338 base) {
        class_2350 face = HideyHomes.getBoundFace(w, base);
        if (face != null) {
            for (int i = 1; i <= 4; ++i) {
                class_2338 p = base.method_10079(face, i);
                if (!HideyHomes.isTwoHighAirWithFloor(w, p)) continue;
                return p;
            }
        }
        for (class_2350 d : class_2350.class_2353.field_11062) {
            class_2338 p = base.method_10093(d);
            if (!HideyHomes.isTwoHighAirWithFloor(w, p)) continue;
            return p;
        }
        return base.method_10086(2);
    }

    public static boolean unbindAtEither(class_3222 sp, class_1937 world, class_2338 clickedPos) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 sw = (class_3218)world;
        class_2338 base = HideyHomes.resolveEntranceBase(sw, clickedPos);
        if (base == null) {
            return false;
        }
        return HideyHomes.unbindEntrance(sp, (class_1937)sw, base);
    }

    private static enum SneakStage {
        IDLE,
        FIRST_CROUCH,
        RELEASED;

    }

    private record EntranceRef(class_5321<class_1937> worldKey, class_2338 pos) {
    }

    private static class State
    extends class_18 {
        final Map<Long, Long> posToRoom = new HashMap<Long, Long>();
        final Map<Long, String> posToFrame = new HashMap<Long, String>();
        final Map<Long, Long> dormant = new HashMap<Long, Long>();
        int nextX = 0;
        int nextZ = 0;
        final Map<Long, String> roomMaterial = new HashMap<Long, String>();
        final Map<Long, String> roomExitWorld = new HashMap<Long, String>();
        final Map<Long, Long> roomExitBase = new HashMap<Long, Long>();

        private State() {
        }

        public class_2487 method_75(class_2487 nbt) {
            long[] keys = new long[this.posToRoom.size()];
            long[] vals = new long[this.posToRoom.size()];
            int i = 0;
            for (Map.Entry<Long, Long> e : this.posToRoom.entrySet()) {
                keys[i] = e.getKey();
                vals[i] = e.getValue();
                ++i;
            }
            class_2487 rooms = new class_2487();
            rooms.method_10564("keys", keys);
            rooms.method_10564("vals", vals);
            rooms.method_10569("nx", this.nextX);
            rooms.method_10569("nz", this.nextZ);
            nbt.method_10566("rooms", (class_2520)rooms);
            long[] fkeys = new long[this.posToFrame.size()];
            CharSequence[] fuids = new String[this.posToFrame.size()];
            i = 0;
            for (Map.Entry<Long, String> e : this.posToFrame.entrySet()) {
                fkeys[i] = e.getKey();
                fuids[i] = e.getValue();
                ++i;
            }
            class_2487 frames = new class_2487();
            frames.method_10564("keys", fkeys);
            frames.method_10582("uids", String.join((CharSequence)",", fuids));
            nbt.method_10566("frames", (class_2520)frames);
            long[] dkeys = new long[this.dormant.size()];
            long[] dvals = new long[this.dormant.size()];
            i = 0;
            for (Map.Entry<Long, Long> e : this.dormant.entrySet()) {
                dkeys[i] = e.getKey();
                dvals[i] = e.getValue();
                ++i;
            }
            class_2487 dorm = new class_2487();
            dorm.method_10564("keys", dkeys);
            dorm.method_10564("vals", dvals);
            nbt.method_10566("dormant", (class_2520)dorm);
            long[] mk = new long[this.roomMaterial.size()];
            CharSequence[] mv = new String[this.roomMaterial.size()];
            int s = 0;
            for (Map.Entry<Long, String> e : this.roomMaterial.entrySet()) {
                mk[s] = e.getKey();
                mv[s] = e.getValue();
                ++i;
            }
            class_2487 mats = new class_2487();
            mats.method_10564("keys", mk);
            mats.method_10582("vals", String.join((CharSequence)",", mv));
            nbt.method_10566("mats", (class_2520)mats);
            long[] exKeys = new long[this.roomExitBase.size()];
            long[] exVals = new long[this.roomExitBase.size()];
            int i2 = 0;
            for (Map.Entry<Long, Long> e : this.roomExitBase.entrySet()) {
                exKeys[i2] = e.getKey();
                exVals[i2] = e.getValue();
                ++i2;
            }
            class_2487 exits = new class_2487();
            exits.method_10564("roomExitKeys", exKeys);
            exits.method_10564("roomExitVals", exVals);
            exits.method_10582("roomExitWorlds", String.join((CharSequence)",", this.roomExitWorld.values()));
            nbt.method_10566("exits", (class_2520)exits);
            return nbt;
        }

        static State readNbt(class_2487 nbt) {
            int i;
            long[] keys;
            State s = new State();
            if (nbt.method_10545("rooms")) {
                class_2487 rooms = nbt.method_10562("rooms");
                keys = rooms.method_10565("keys");
                long[] vals = rooms.method_10565("vals");
                for (i = 0; i < Math.min(keys.length, vals.length); ++i) {
                    s.posToRoom.put(keys[i], vals[i]);
                }
                s.nextX = rooms.method_10550("nx");
                s.nextZ = rooms.method_10550("nz");
            }
            if (nbt.method_10545("frames")) {
                class_2487 f = nbt.method_10562("frames");
                keys = f.method_10565("keys");
                String[] uuids = f.method_10558("uids").isEmpty() ? new String[]{} : f.method_10558("uids").split(",");
                for (i = 0; i < Math.min(keys.length, uuids.length); ++i) {
                    s.posToFrame.put(keys[i], uuids[i]);
                }
            }
            if (nbt.method_10545("dormant")) {
                class_2487 d = nbt.method_10562("dormant");
                long[] dk = d.method_10565("keys");
                long[] dv = d.method_10565("vals");
                for (i = 0; i < Math.min(dk.length, dv.length); ++i) {
                    s.dormant.put(dk[i], dv[i]);
                }
            }
            if (nbt.method_10545("mats")) {
                class_2487 m = nbt.method_10562("mats");
                long[] mk = m.method_10565("keys");
                String[] mv = m.method_10558("vals").isEmpty() ? new String[]{} : m.method_10558("vals").split(",");
                for (i = 0; i < Math.min(mk.length, mv.length); ++i) {
                    s.roomMaterial.put(mk[i], mv[i]);
                }
            }
            if (nbt.method_10545("exits")) {
                class_2487 ex = nbt.method_10562("exits");
                long[] exKeys = ex.method_10565("roomExitKeys");
                long[] exVals = ex.method_10565("roomExitVals");
                String[] worlds = ex.method_10558("roomExitWorlds").isEmpty() ? new String[]{} : ex.method_10558("roomExitWorlds").split(",");
                for (int i2 = 0; i2 < Math.min(Math.min(exKeys.length, exVals.length), worlds.length); ++i2) {
                    s.roomExitBase.put(exKeys[i2], exVals[i2]);
                    s.roomExitWorld.put(exKeys[i2], worlds[i2]);
                }
            }
            return s;
        }
    }
}

