/*
 * Decompiled with CFR 0.152.
 */
package com.casualhorizons.gulliverlite;

import com.casualhorizons.gulliverlite.GulliverLite;
import com.casualhorizons.gulliverlite.SizeUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7157;

public final class SizeCommand {
    private static final float[] SCALES = SizeUtil.ALLOWED_SCALES;

    private SizeCommand() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register(SizeCommand::registerInternal);
    }

    private static void registerInternal(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"size");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(src -> true)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"micro").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 0, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"tiny").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 1, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"small").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 2, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"normal").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 3, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"large").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 4, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"huge").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 5, SizeCommand.self((CommandContext<class_2168>)ctx)))))).then(class_2170.method_9247((String)"next").executes(ctx -> SizeCommand.step((CommandContext<class_2168>)ctx, 1, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"prev").executes(ctx -> SizeCommand.step((CommandContext<class_2168>)ctx, -1, SizeCommand.self((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"reset").executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 3, SizeCommand.self((CommandContext<class_2168>)ctx))));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"micro").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 0, class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"tiny").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 1, class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"small").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 2, class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"normal").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 3, class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"large").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 4, class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"huge").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 5, class_2186.method_9312((CommandContext)ctx, (String)"targets"))))));
        root.then(class_2170.method_9247((String)"next").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.step((CommandContext<class_2168>)ctx, 1, class_2186.method_9312((CommandContext)ctx, (String)"targets")))));
        root.then(class_2170.method_9247((String)"prev").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.step((CommandContext<class_2168>)ctx, -1, class_2186.method_9312((CommandContext)ctx, (String)"targets")))));
        root.then(class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(src -> src.method_9259(2))).executes(ctx -> SizeCommand.setMode((CommandContext<class_2168>)ctx, 3, class_2186.method_9312((CommandContext)ctx, (String)"targets")))));
        dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"shrink").redirect(dispatcher.getRoot().getChild("size")));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"grow").redirect(dispatcher.getRoot().getChild("size")));
    }

    private static int setMode(CommandContext<class_2168> ctx, int mode, Collection<class_3222> targets) {
        int clampedMode = SizeCommand.clamp(mode, 0, SCALES.length - 1);
        float target = SCALES[clampedMode];
        int count = 0;
        for (class_3222 p : targets) {
            SizeUtil.setExactScale((class_1657)p, target);
            SizeCommand.sendFeedbackAndSound(p, clampedMode);
            ++count;
        }
        int resultCount = count;
        if (targets.size() > 1 || ((class_2168)ctx.getSource()).method_9228() == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Set size to " + SizeCommand.sizeName(clampedMode) + " for " + resultCount + " player(s).")), true);
        }
        return resultCount;
    }

    private static int step(CommandContext<class_2168> ctx, int delta, Collection<class_3222> targets) {
        int count = 0;
        for (class_3222 p : targets) {
            float current = SizeUtil.getScale((class_1657)p);
            int idx = SizeUtil.nearestAllowedIndex(current);
            int next = SizeCommand.clamp(idx + delta, 0, SCALES.length - 1);
            SizeUtil.setExactScale((class_1657)p, SCALES[next]);
            SizeCommand.sendFeedbackAndSound(p, next);
            ++count;
        }
        int resultCount = count;
        if (targets.size() > 1 || ((class_2168)ctx.getSource()).method_9228() == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Adjusted size for " + resultCount + " player(s).")), true);
        }
        return resultCount;
    }

    private static Collection<class_3222> self(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        class_1297 class_12972 = src.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 sp = (class_3222)class_12972;
            return List.of(sp);
        }
        src.method_9226(() -> class_2561.method_43470((String)"Specify targets when running from console or command blocks."), false);
        return List.of();
    }

    private static void sendFeedbackAndSound(class_3222 p, int mode) {
        p.method_7353((class_2561)class_2561.method_43470((String)("Size: " + SizeCommand.sizeName(mode) + (GulliverLite.PEHKUI_LOADED ? "" : " (Pehkui not found)"))), true);
        float pitch = switch (mode) {
            case 0 -> 1.8f;
            case 1 -> 1.5f;
            case 2 -> 1.2f;
            case 3 -> 1.0f;
            case 4 -> 0.8f;
            default -> 0.6f;
        };
        p.method_51469().method_8396(null, p.method_24515(), (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 0.8f, pitch);
    }

    private static String sizeName(int mode) {
        return switch (mode) {
            case 0 -> "Micro";
            case 1 -> "Tiny";
            case 2 -> "Small";
            case 3 -> "Normal";
            case 4 -> "Large";
            default -> "Huge";
        };
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }
}

