/*
 * Decompiled with CFR 0.152.
 */
package com.casualhorizons.gulliverlite;

import com.casualhorizons.gulliverlite.GulliverLite;
import net.minecraft.class_1297;
import net.minecraft.class_1657;

public class SizeUtil {
    public static final float[] ALLOWED_SCALES = new float[]{0.0625f, 0.125f, 0.25f, 1.0f, 3.0f, 6.0f};
    private static final float SNAP_EPSILON = 0.01f;

    public static float getScale(class_1657 player) {
        if (!GulliverLite.PEHKUI_LOADED) {
            return 1.0f;
        }
        try {
            Class<?> scaleTypes = Class.forName("virtuoel.pehkui.api.ScaleTypes");
            Object BASE = scaleTypes.getDeclaredField("BASE").get(null);
            Class<?> scaleTypeCls = Class.forName("virtuoel.pehkui.api.ScaleType");
            Class<?> scaleDataCls = Class.forName("virtuoel.pehkui.api.ScaleData");
            Object data = scaleTypeCls.getMethod("getScaleData", class_1297.class).invoke(BASE, player);
            Object val = scaleDataCls.getMethod("getScale", new Class[0]).invoke(data, new Object[0]);
            return ((Number)val).floatValue();
        }
        catch (Throwable t) {
            return 1.0f;
        }
    }

    public static int nearestAllowedIndex(float value) {
        int best = 0;
        float bestDiff = Math.abs(value - ALLOWED_SCALES[0]);
        for (int i = 1; i < ALLOWED_SCALES.length; ++i) {
            float d = Math.abs(value - ALLOWED_SCALES[i]);
            if (!(d < bestDiff)) continue;
            bestDiff = d;
            best = i;
        }
        return best;
    }

    public static boolean isSmallerThanNormal(class_1657 player) {
        return SizeUtil.getScale(player) < 0.99f;
    }

    public static void snapToAllowed(class_1657 player) {
        if (!GulliverLite.PEHKUI_LOADED) {
            return;
        }
        try {
            float current = SizeUtil.getScale(player);
            int idx = SizeUtil.nearestAllowedIndex(current);
            float target = ALLOWED_SCALES[idx];
            if (Math.abs(current - target) <= 0.01f) {
                return;
            }
            Class<?> scaleTypes = Class.forName("virtuoel.pehkui.api.ScaleTypes");
            Object BASE = scaleTypes.getDeclaredField("BASE").get(null);
            Class<?> scaleTypeCls = Class.forName("virtuoel.pehkui.api.ScaleType");
            Class<?> scaleDataCls = Class.forName("virtuoel.pehkui.api.ScaleData");
            Object data = scaleTypeCls.getMethod("getScaleData", class_1297.class).invoke(BASE, player);
            try {
                scaleDataCls.getMethod("setTargetScale", Float.TYPE, Integer.TYPE).invoke(data, Float.valueOf(target), 0);
            }
            catch (NoSuchMethodException ignored) {
                scaleDataCls.getMethod("setTargetScale", Float.TYPE).invoke(data, Float.valueOf(target));
            }
            scaleDataCls.getMethod("setScale", Float.TYPE).invoke(data, Float.valueOf(target));
            try {
                scaleDataCls.getMethod("markForSync", Boolean.TYPE).invoke(data, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setExactScale(class_1657 player, float scale) {
        if (!GulliverLite.PEHKUI_LOADED) {
            return;
        }
        try {
            Class<?> scaleTypes = Class.forName("virtuoel.pehkui.api.ScaleTypes");
            Object BASE = scaleTypes.getDeclaredField("BASE").get(null);
            Class<?> scaleTypeCls = Class.forName("virtuoel.pehkui.api.ScaleType");
            Class<?> scaleDataCls = Class.forName("virtuoel.pehkui.api.ScaleData");
            Object data = scaleTypeCls.getMethod("getScaleData", class_1297.class).invoke(BASE, player);
            try {
                scaleDataCls.getMethod("setTargetScale", Float.TYPE, Integer.TYPE).invoke(data, Float.valueOf(scale), 0);
            }
            catch (NoSuchMethodException ignored) {
                scaleDataCls.getMethod("setTargetScale", Float.TYPE).invoke(data, Float.valueOf(scale));
            }
            scaleDataCls.getMethod("setScale", Float.TYPE).invoke(data, Float.valueOf(scale));
            try {
                scaleDataCls.getMethod("markForSync", Boolean.TYPE).invoke(data, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

